@extends('layouts.admin')

@section('title', 'View Case')

@section('content')
    <div class="header" style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 2rem;">
        <div>
            <h1 style="margin-bottom: 0.5rem">{{ $case->title }}</h1>
            <p>{{ $case->reference_number }} - Created on {{ $case->created_at->format('M d, Y') }}</p>
        </div>
        <div style="display: flex; gap: 0.5rem;">
            <a href="{{ route('admin.cases.index') }}" class="btn" style="background: #e2e8f0; color: #475569;">Back</a>
            <a href="{{ route('admin.cases.edit', $case->id) }}" class="btn" style="background: #3b82f6; color: white;">Edit</a>
            @if($case->status !== 'archived')
            <form action="{{ route('admin.cases.archive', $case->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to archive this case?');">
                @csrf
                <button type="submit" class="btn" style="background: #64748b; color: white;">Archive</button>
            </form>
            @endif
        </div>
    </div>

    <div class="card-grid" style="grid-template-columns: 2fr 1fr;">
        <!-- Left Column: Case Details -->
        <div style="display: flex; flex-direction: column; gap: 1.5rem;">
            <div class="card">
                <div class="card-header">
                    <h3>Description</h3>
                </div>
                <div style="white-space: pre-wrap; line-height: 1.6; color: #334155;">{{ $case->description }}</div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3>Case Information</h3>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <div class="form-label">Category</div>
                        <div>{{ ucfirst(str_replace('_', ' ', $case->category)) }}</div>
                    </div>
                    <div>
                        <div class="form-label">Incident Date</div>
                        <div>{{ $case->incident_date->format('M d, Y') }}</div>
                    </div>
                    <div>
                        <div class="form-label">Employer</div>
                        <div>{{ $case->employer_name ?? 'N/A' }}</div>
                    </div>
                     <div>
                        <div class="form-label">Urgency</div>
                        <span class="badge" style="
                            padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.8em;
                            background: {{ $case->urgency == 'critical' ? '#ffebe6' : ($case->urgency == 'high' ? '#fff4e5' : '#e6fcff') }};
                            color: {{ $case->urgency == 'critical' ? '#bf2600' : ($case->urgency == 'high' ? '#b76e00' : '#006644') }};
                        ">
                            {{ ucfirst($case->urgency) }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column: Member Info & Status -->
        <div style="display: flex; flex-direction: column; gap: 1.5rem;">
            <div class="card">
                <div class="card-header">
                    <h3>Status</h3>
                </div>
                <div style="font-size: 1.2rem; font-weight: 600; text-transform: capitalize; margin-bottom: 0.5rem;">
                    {{ str_replace('_', ' ', $case->status) }}
                </div>
                <div style="color: #64748b; font-size: 0.9rem;">
                    Last updated {{ $case->updated_at->diffForHumans() }}
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3>Member Details</h3>
                </div>
                @if($case->user)
                    <div style="display: flex; gap: 1rem; align-items: center; margin-bottom: 1rem;">
                        <div style="width: 48px; height: 48px; background: #e2e8f0; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; color: #64748b;">
                            {{ substr($case->user->first_name ?? 'U', 0, 1) }}
                        </div>
                        <div>
                            <div style="font-weight: 600;">{{ $case->user->first_name }} {{ $case->user->last_name }}</div>
                            <div style="font-size: 0.9rem; color: #64748b;">{{ $case->user->email }}</div>
                        </div>
                    </div>
                    <div>
                        <a href="#" style="font-size: 0.9rem; color: #3b82f6; text-decoration: none;">View Member Profile &rarr;</a>
                    </div>
                @else
                    <div style="color: #64748b;">Unknown Member</div>
                @endif
            </div>
        </div>
    </div>
@endsection
