@extends('layouts.admin')

@section('title', 'Edit Case')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Case: {{ $case->reference_number }}</h3>
        </div>
        <div class="card-body">
            @if($errors->any())
                <div class="alert alert-danger" style="color: red; margin-bottom: 1rem;">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.cases.update', $case->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Member</label>
                    <input type="text" class="form-control" value="{{ $case->user->first_name ?? '' }} {{ $case->user->last_name ?? 'Unknown' }}" disabled style="background: #f1f5f9;">
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Status</label>
                    <select name="status" class="form-control" required>
                        <option value="submitted" {{ old('status', $case->status) == 'submitted' ? 'selected' : '' }}>Submitted</option>
                        <option value="in_progress" {{ old('status', $case->status) == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="resolved" {{ old('status', $case->status) == 'resolved' ? 'selected' : '' }}>Resolved</option>
                        <option value="archived" {{ old('status', $case->status) == 'archived' ? 'selected' : '' }}>Archived</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Case Title / Subject</label>
                    <input type="text" name="title" value="{{ old('title', $case->title) }}" class="form-control" required>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Category</label>
                    <select name="category" class="form-control" required>
                        <option value="disciplinary" {{ old('category', $case->category) == 'disciplinary' ? 'selected' : '' }}>Disciplinary Hearing</option>
                        <option value="wage_dispute" {{ old('category', $case->category) == 'wage_dispute' ? 'selected' : '' }}>Wage Dispute</option>
                        <option value="unfair_dismissal" {{ old('category', $case->category) == 'unfair_dismissal' ? 'selected' : '' }}>Unfair Dismissal</option>
                        <option value="safety" {{ old('category', $case->category) == 'safety' ? 'selected' : '' }}>Safety Violation</option>
                        <option value="harassment" {{ old('category', $case->category) == 'harassment' ? 'selected' : '' }}>Harassment</option>
                        <option value="other" {{ old('category', $case->category) == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Employer / Workplace</label>
                    <input type="text" name="employer_name" value="{{ old('employer_name', $case->employer_name) }}" class="form-control">
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Incident Date</label>
                    <input type="date" name="incident_date" value="{{ old('incident_date', $case->incident_date ? $case->incident_date->format('Y-m-d') : '') }}" class="form-control" required>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Urgency Level</label>
                    <select name="urgency" class="form-control" required>
                        <option value="low" {{ old('urgency', $case->urgency) == 'low' ? 'selected' : '' }}>Low</option>
                        <option value="medium" {{ old('urgency', $case->urgency) == 'medium' ? 'selected' : '' }}>Medium</option>
                        <option value="high" {{ old('urgency', $case->urgency) == 'high' ? 'selected' : '' }}>High</option>
                        <option value="critical" {{ old('urgency', $case->urgency) == 'critical' ? 'selected' : '' }}>Critical</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Description</label>
                    <textarea name="description" rows="5" class="form-control" required>{{ old('description', $case->description) }}</textarea>
                </div>

                <div style="display: flex; gap: 1rem;">
                     <button type="submit" class="btn btn-primary">Update Case</button>
                     <a href="{{ route('admin.cases.index') }}" class="btn" style="background: #e2e8f0; color: #475569;">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection
