@extends('layouts.admin')

@section('title', 'Create New Case')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Open New Case</h3>
        </div>
        <div class="card-body">
            @if($errors->any())
                <div class="alert alert-danger" style="color: red; margin-bottom: 1rem;">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.cases.store') }}" method="POST">
                @csrf
                
                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Select Member</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">-- Choose Member --</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->first_name }} {{ $user->last_name }} ({{ $user->email }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Employer / Workplace</label>
                    <input type="text" name="employer_name" value="{{ old('employer_name') }}" class="form-control" placeholder="E.g. ABC Manufacturing">
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Case Title / Subject</label>
                    <input type="text" name="title" value="{{ old('title') }}" class="form-control" required placeholder="Brief summary of the case">
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Category</label>
                    <select name="category" class="form-control" required>
                        <option value="">-- Select Category --</option>
                        <option value="disciplinary" {{ old('category') == 'disciplinary' ? 'selected' : '' }}>Disciplinary Hearing</option>
                        <option value="wage_dispute" {{ old('category') == 'wage_dispute' ? 'selected' : '' }}>Wage Dispute</option>
                        <option value="unfair_dismissal" {{ old('category') == 'unfair_dismissal' ? 'selected' : '' }}>Unfair Dismissal</option>
                        <option value="safety" {{ old('category') == 'safety' ? 'selected' : '' }}>Safety Violation</option>
                        <option value="harassment" {{ old('category') == 'harassment' ? 'selected' : '' }}>Harassment</option>
                        <option value="other" {{ old('category') == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Incident Date</label>
                    <input type="date" name="incident_date" value="{{ old('incident_date') }}" class="form-control" required>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Urgency Level</label>
                    <select name="urgency" class="form-control" required>
                        <option value="low" {{ old('urgency') == 'low' ? 'selected' : '' }}>Low</option>
                        <option value="medium" {{ old('urgency') == 'medium' ? 'selected' : '' }}>Medium</option>
                        <option value="high" {{ old('urgency') == 'high' ? 'selected' : '' }}>High</option>
                        <option value="critical" {{ old('urgency') == 'critical' ? 'selected' : '' }}>Critical (Immediate Action)</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Description (Statement)</label>
                    <textarea name="description" rows="5" class="form-control" required>{{ old('description') }}</textarea>
                </div>

                <button type="submit" class="btn btn-primary">Submit Case</button>
            </form>
        </div>
    </div>
@endsection
