#!/bin/sh
set -e

# Wait for database (simple check, or rely on depends_on/restart policy)
# echo "Waiting for database..."

# Run migrations
echo "Running migrations..."
php artisan migrate --force

# Optimize/Cache
echo "Caching configuration and routes..."
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Link storage
if [ ! -d "/var/www/public/storage" ]; then
    echo "Linking storage..."
    php artisan storage:link
fi

# Fix permissions for storage if needed (though Dockerfile handles this mostly)
# chown -R www-data:www-data /var/www/storage

echo "Starting PHP-FPM..."
exec "$@"
