<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            [
                'group' => 'general',
                'key' => 'app_name',
                'value' => 'MTWU Admin',
                'type' => 'string',
                'description' => 'The name of the application displayed in the header and emails.',
                'is_system' => true,
            ],
            [
                'group' => 'general',
                'key' => 'contact_email',
                'value' => 'support@mtwu.co.za',
                'type' => 'string',
                'description' => 'Public contact email address.',
                'is_system' => true,
            ],
            [
                'group' => 'system',
                'key' => 'maintenance_mode',
                'value' => '0',
                'type' => 'boolean',
                'description' => 'Enable maintenance mode to prevent non-admin access.',
                'is_system' => true,
            ],
            [
                'group' => 'notifications',
                'key' => 'enable_email_notifications',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Global switch to enable/disable all email notifications.',
                'is_system' => true,
            ],
             [
                'group' => 'notifications',
                'key' => 'enable_push_notifications',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Global switch to enable/disable all push notifications.',
                'is_system' => true,
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(['key' => $setting['key']], $setting);
        }
    }
}
