<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $permissions = [
            'manage users', 'view reports', // Regional Admin
            'create content', 'edit content', 'delete content', 'publish content', // Content Manager
            'view finance reports', 'export finance data', // Finance Officer
            'view user profiles', 'reset user passwords', // Support Agent
        ];

        $guards = ['web', 'api'];

        foreach ($guards as $guard) {
            foreach ($permissions as $permission) {
                \Spatie\Permission\Models\Permission::findOrCreate($permission, $guard);
            }

            // Create Roles and Assign Permissions for this guard
            
            // 1. Super Admin
            $role = \Spatie\Permission\Models\Role::findOrCreate('Super Admin', $guard);
            $role->givePermissionTo(\Spatie\Permission\Models\Permission::where('guard_name', $guard)->get());

            // 2. Regional Admin
            $role = \Spatie\Permission\Models\Role::findOrCreate('Regional Admin', $guard);
            $role->givePermissionTo(['manage users', 'view reports']);

            // 3. Content Manager
            $role = \Spatie\Permission\Models\Role::findOrCreate('Content Manager', $guard);
            $role->givePermissionTo(['create content', 'edit content', 'delete content', 'publish content']);

            // 4. Finance Officer
            $role = \Spatie\Permission\Models\Role::findOrCreate('Finance Officer', $guard);
            $role->givePermissionTo(['view finance reports', 'export finance data']);

            // 5. Support Agent
            $role = \Spatie\Permission\Models\Role::findOrCreate('Support Agent', $guard);
            $role->givePermissionTo(['view user profiles', 'reset user passwords']);

            // 6. Member
            $role = \Spatie\Permission\Models\Role::findOrCreate('member', $guard);
            // Permissions for member can be added here later
        }

        // Create a Super Admin User
        $user = \App\Models\User::firstOrCreate(
            ['email' => 'admin@mtwu.com'],
            [
                'name' => 'Super Admin',
                'password' => bcrypt('password'),
            ]
        );
        
        // Assign Super Admin role for both guards
        $user->assignRole(\Spatie\Permission\Models\Role::findByName('Super Admin', 'web'));
        $user->assignRole(\Spatie\Permission\Models\Role::findByName('Super Admin', 'api'));
    }
}
