<?php

namespace Database\Seeders;

use App\Models\Province;
use Illuminate\Database\Seeder;

class ProvinceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $provinces = [
            ['name' => 'Eastern Cape', 'code' => 'EC'],
            ['name' => 'Free State', 'code' => 'FS'],
            ['name' => 'Gauteng', 'code' => 'GP'],
            ['name' => 'KwaZulu-Natal', 'code' => 'KZN'],
            ['name' => 'Limpopo', 'code' => 'LP'],
            ['name' => 'Mpumalanga', 'code' => 'MP'],
            ['name' => 'North West', 'code' => 'NW'],
            ['name' => 'Northern Cape', 'code' => 'NC'],
            ['name' => 'Western Cape', 'code' => 'WC'],
        ];

        foreach ($provinces as $province) {
            Province::firstOrCreate(
                ['name' => $province['name']],
                ['code' => $province['code']]
            );
        }
    }
}
