<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Rename Fees to Payments
        if (Schema::hasTable('fees')) {
            Schema::rename('fees', 'payments');
        }

        // 2. Update Payments Table
        Schema::table('payments', function (Blueprint $table) {
            $table->string('method')->nullable()->after('amount'); // e.g., EFT, Debit Order
            $table->string('reference')->nullable()->after('method');
            $table->text('notes')->nullable();
        });

        // 3. Create Fee Structures Table
        Schema::create('fee_structures', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Standard Membership"
            $table->decimal('amount', 10, 2);
            $table->string('frequency')->default('monthly'); // monthly, annual, one-time
            $table->json('criteria')->nullable(); // Auto-assignment rules
            $table->timestamps();
        });

        // 4. Create Subscriptions Table (MemberFees)
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('fee_structure_id')->constrained()->onDelete('restrict');
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->string('status')->default('active'); // active, inactive, cancelled
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
        Schema::dropIfExists('fee_structures');
        
        if (Schema::hasColumn('payments', 'method')) {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropColumn(['method', 'reference', 'notes']);
            });
        }

        if (Schema::hasTable('payments')) {
            Schema::rename('payments', 'fees');
        }
    }
};
