<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('grievances', function (Blueprint $table) {
            $table->string('reference_number')->unique()->nullable()->after('id');
            $table->string('employer_name')->nullable()->after('description');
            $table->string('category')->nullable()->after('employer_name'); // e.g., disciplinary, wage_dispute
            $table->date('incident_date')->nullable()->after('category');
            $table->enum('urgency', ['low', 'medium', 'high', 'critical'])->default('medium')->after('incident_date');
            
            // Updating status column if needed, but it's already string in previous migration. 
            // We'll rely on model validation for status 'submitted'.
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('grievances', function (Blueprint $table) {
            $table->dropColumn(['reference_number', 'employer_name', 'category', 'incident_date', 'urgency']);
        });
    }
};
