<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('messages', function (Blueprint $table) {
            $table->string('title')->after('id');
            $table->enum('type', ['announcement', 'alert', 'reminder', 'circular', 'emergency'])->after('title');
            $table->enum('status', ['draft', 'published', 'archived'])->default('draft')->after('content');
            $table->timestamp('published_at')->nullable()->after('status');
            if (DB::getDriverName() !== 'sqlite') {
                $table->foreignId('receiver_id')->nullable()->change(); // Nullable for global announcements
            }
        });

        Schema::create('message_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('message_id')->constrained('messages')->onDelete('cascade');
            $table->string('file_path');
            $table->string('file_name');
            $table->string('mime_type')->nullable();
            $table->unsignedBigInteger('file_size')->nullable(); // in bytes
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('message_attachments');

        Schema::table('messages', function (Blueprint $table) {
            $table->dropColumn(['title', 'type', 'status', 'published_at']);
            $table->foreignId('receiver_id')->nullable(false)->change();
        });
    }
};
