<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('members', function (Blueprint $table) {
            $table->dropColumn('postal_address');
            
            // Home Address
            $table->string('home_address_line1')->nullable()->after('monthly_wages');
            $table->string('home_address_line2')->nullable()->after('home_address_line1');
            $table->string('home_city')->nullable()->after('home_address_line2');
            $table->string('home_code')->nullable()->after('home_city');
            
            // Postal Address
            $table->string('postal_box')->nullable()->after('home_code');
            $table->string('postal_city')->nullable()->after('postal_box');
            $table->string('postal_code')->nullable()->after('postal_city');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            //
        });
    }
};
