<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('members', function (Blueprint $table) {
            $table->string('identity_number')->unique()->nullable()->after('last_name');
            $table->enum('gender', ['Male', 'Female'])->nullable()->after('identity_number');
            $table->decimal('monthly_wages', 10, 2)->nullable()->after('gender');
            $table->text('postal_address')->nullable()->after('monthly_wages');
            $table->string('previous_union')->nullable()->after('postal_address');
            $table->string('recruiter_name')->nullable()->after('previous_union');
            $table->date('agreement_date')->nullable()->after('recruiter_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('members', function (Blueprint $table) {
            //
        });
    }
};
