<?php

namespace App\Services;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;

class FileService extends BaseService
{
    /**
     * Upload a file to storage.
     *
     * @param UploadedFile $file
     * @param string $path
     * @return string
     */
    public function upload(UploadedFile $file, string $path = 'uploads'): string
    {
        // For production, ensure 's3' is configured in filesystems.php
        $disk = env('FILESYSTEM_DISK', 'local');

        return $file->store($path, $disk);
    }

    /**
     * Delete a file from storage.
     *
     * @param string $path
     * @return bool
     */
    public function delete(string $path): bool
    {
        $disk = env('FILESYSTEM_DISK', 'local');

        if (Storage::disk($disk)->exists($path)) {
            return Storage::disk($disk)->delete($path);
        }

        return false;
    }
}
