<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;
use Laravel\Sanctum\HasApiTokens;

class Member extends Authenticatable
{
    use HasFactory, SoftDeletes, HasApiTokens, Notifiable;

    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'identity_number',
        'gender',
        'monthly_wages',
        'designation',
        'home_address_line1',
        'home_address_line2',
        'home_city',
        'home_code',
        'home_province',
        'postal_box',
        'postal_city',
        'postal_code',
        'postal_province',
        'recruiter_name',
        'agreement_date',
        'phone',
        'workplace',
        'status',
        'dues_status',
        'digital_id',
        'joined_at',
        'password',
        'profile_picture'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'joined_at' => 'datetime',
        'agreement_date' => 'date',
    ];

    /**
     * Boot function from Laravel.
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->digital_id)) {
                // Generate a unique Digital ID, e.g., MTWU-YEAR-RANDOM
                $model->digital_id = 'MTWU-' . date('Y') . '-' . strtoupper(Str::random(6));
            }
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
