<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Grievance extends Model
{
    use \Illuminate\Database\Eloquent\Factories\HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'description',
        'status',
        'region',
        'department',
        'reference_number',
        'employer_name',
        'category',
        'incident_date',
        'urgency',
    ];

    protected $casts = [
        'incident_date' => 'date',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->reference_number)) {
                $count = static::whereYear('created_at', date('Y'))->count() + 1;
                $model->reference_number = 'CASE-' . date('Y') . '-' . str_pad($count, 6, '0', STR_PAD_LEFT);
            }
            if (empty($model->status)) {
                $model->status = 'submitted';
            }
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
