<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInstalled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $installedFile = storage_path('installed');

        // Check if the application is installed
        if (file_exists($installedFile)) {
            // If installed and user accesses installer routes, redirect to home
            if ($request->is('install') || $request->is('install/*')) {
                return redirect('/');
            }
        } else {
            // If NOT installed and user accesses non-installer routes, redirect to install
            if (!$request->is('install') && !$request->is('install/*')) {
                return redirect('/install');
            }
        }

        return $next($request);
    }
}
