<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\AuditLog;

class AuditLogMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Only log write operations usually, or whatever is critical.
        // For admin panel, maybe log everything except GET? Or specific critical GETs?
        // Let's log POST, PUT, PATCH, DELETE.

        if (in_array($request->method(), ['POST', 'PUT', 'PATCH', 'DELETE'])) {
            $user = Auth::user();

            if ($user) {
                AuditLog::create([
                    'user_id' => $user->id,
                    'action' => $request->method(),
                    'module' => $request->path(), // Or determine module from route name
                    'details' => $request->except(['password', 'password_confirmation', 'file']), // Be careful with passwords!
                    'ip_address' => $request->ip(),
                ]);
            }
        }

        return $response;
    }
}
