<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\DashboardService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Traits\ApiResponse;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class DashboardController extends Controller implements HasMiddleware
{
    use ApiResponse;

    protected $dashboardService;

    public function __construct(DashboardService $dashboardService)
    {
        $this->dashboardService = $dashboardService;
    }

    public static function middleware(): array
    {
        return [
            new Middleware('auth:api'),
            // Optionally restrict to admin roles
            // new Middleware('role:Super Admin|Regional Admin'),
        ];
    }

    /**
     * Get dashboard overview statistics.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function stats(Request $request): JsonResponse
    {
        try {
            $filters = $request->only(['region', 'department', 'start_date', 'end_date']);
            
            $data = [
                'stats' => $this->dashboardService->getStats($filters),
                'recent_activity' => $this->dashboardService->getRecentActivity(),
                'alerts' => $this->dashboardService->getPendingAlerts(),
            ];

            return $this->success($data, 'Dashboard statistics retrieved successfully');
        } catch (\Exception $e) {
            return $this->error('Failed to fetch dashboard stats: ' . $e->getMessage(), 500);
        }
    }
}
