<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Grievance;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CaseController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'category' => 'required|string',
            'description' => 'required|string',
            'incident_date' => 'required|date',
            'urgency' => 'required|in:low,medium,high,critical',
            'employer_name' => 'nullable|string',
        ]);

        $validated['user_id'] = Auth::id(); // Assign to authenticated user

        $case = Grievance::create($validated);

        return response()->json([
            'message' => 'Case submitted successfully',
            'case' => $case,
        ], 201);
    }
}
