<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::all()->groupBy('group');
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->except('_token', '_method');

        foreach ($data as $key => $value) {
            $setting = Setting::where('key', $key)->first();
            if ($setting) {
                // Determine if we need to encode json
                if ($setting->type === 'json') {
                    $value = json_encode($value);
                }
                
                $setting->value = $value;
                $setting->save();
            }
        }

        // Handle checkboxes/booleans that are unchecked (not sent in request)
        // We get all boolean settings and check if they are in the request
        $booleanSettings = Setting::where('type', 'boolean')->get();
        foreach ($booleanSettings as $setting) {
             if (!array_key_exists($setting->key, $data)) {
                 $setting->value = 0; // Set to false if missing from request
                 $setting->save();
             }
        }

        return redirect()->back()->with('success', 'Settings updated successfully.');
    }
}
