<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Province;
use App\Models\Region;
use Illuminate\Http\Request;

class OrganizationController extends Controller
{
    public function index()
    {
        $provinces = Province::with('regions.branches')->get();
        $regions = Region::with('province')->get();
        $branches = Branch::with('region.province')->get();

        return view('admin.organization.index', compact('provinces', 'regions', 'branches'));
    }

    // --- Province Methods ---
    public function storeProvince(Request $request)
    {
        $request->validate([
            'name' => 'required|string|unique:provinces,name',
            'code' => 'nullable|string|max:10',
        ]);

        Province::create($request->all());

        return redirect()->back()->with('success', 'Province created successfully.');
    }

    public function updateProvince(Request $request, Province $province)
    {
        $request->validate([
            'name' => 'required|string|unique:provinces,name,' . $province->id,
            'code' => 'nullable|string|max:10',
        ]);

        $province->update($request->all());

        return redirect()->back()->with('success', 'Province updated successfully.');
    }

    public function destroyProvince(Province $province)
    {
        $province->delete();
        return redirect()->back()->with('success', 'Province deleted successfully.');
    }

    // --- Region Methods ---
    public function storeRegion(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'province_id' => 'required|exists:provinces,id',
        ]);

        Region::create($request->all());

        return redirect()->back()->with('success', 'Region created successfully.');
    }

    public function updateRegion(Request $request, Region $region)
    {
        $request->validate([
            'name' => 'required|string',
            'province_id' => 'required|exists:provinces,id',
        ]);

        $region->update($request->all());

        return redirect()->back()->with('success', 'Region updated successfully.');
    }

    public function destroyRegion(Region $region)
    {
        $region->delete();
        return redirect()->back()->with('success', 'Region deleted successfully.');
    }

    // --- Branch Methods ---
    public function storeBranch(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'code' => 'nullable|string',
            'region_id' => 'required|exists:regions,id',
        ]);

        Branch::create($request->all());

        return redirect()->back()->with('success', 'Branch created successfully.');
    }

    public function updateBranch(Request $request, Branch $branch)
    {
        $request->validate([
            'name' => 'required|string',
            'code' => 'nullable|string',
            'region_id' => 'required|exists:regions,id',
        ]);

        $branch->update($request->all());

        return redirect()->back()->with('success', 'Branch updated successfully.');
    }

    public function destroyBranch(Branch $branch)
    {
        $branch->delete();
        return redirect()->back()->with('success', 'Branch deleted successfully.');
    }
}
