<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FinanceController extends Controller
{
    protected $feeCalculator;

    public function __construct(\App\Services\FeeCalculatorService $feeCalculator)
    {
        $this->feeCalculator = $feeCalculator;
    }

    public function contributions()
    {
        $members = \App\Models\User::role('member')->with(['subscriptions.feeStructure', 'payments'])->paginate(15);
        
        // Calculate status for each member
        foreach ($members as $member) {
            $member->balance = $this->feeCalculator->calculateBalance($member);
            $member->status = $this->feeCalculator->getStatus($member);
        }

        return view('admin.finance.contributions', compact('members'));
    }

    public function memberHistory($id)
    {
        $member = \App\Models\User::with(['subscriptions.feeStructure', 'payments' => function($q) {
            $q->orderBy('date', 'desc');
        }])->findOrFail($id);

        $balance = $this->feeCalculator->calculateBalance($member);
        $status = $this->feeCalculator->getStatus($member);

        return view('admin.finance.member_history', compact('member', 'balance', 'status'));
    }

    public function records()
    {
        return view('admin.finance.records');
    }

    public function receipts()
    {
        return view('admin.finance.receipts');
    }
}
