<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FeeStructure;
use Illuminate\Http\Request;

class FeeStructureController extends Controller
{
    public function index()
    {
        $structures = FeeStructure::all();
        return view('admin.finance.fees.index', compact('structures'));
    }

    public function create()
    {
        return view('admin.finance.fees.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'amount' => 'required|numeric|min:0',
            'frequency' => 'required|in:monthly,annual,one-time',
        ]);

        FeeStructure::create($validated);

        return redirect()->route('admin.finance.fee-structures.index')
            ->with('success', 'Fee Structure created successfully.');
    }

    public function edit(FeeStructure $feeStructure)
    {
        return view('admin.finance.fees.edit', compact('feeStructure'));
    }

    public function update(Request $request, FeeStructure $feeStructure)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'amount' => 'required|numeric|min:0',
            'frequency' => 'required|in:monthly,annual,one-time',
        ]);

        $feeStructure->update($validated);

        return redirect()->route('admin.finance.fee-structures.index')
            ->with('success', 'Fee Structure updated successfully.');
    }

    public function destroy(FeeStructure $feeStructure)
    {
        // Check for subscriptions before deleting? 
        // For now, strict foreign key constraint might handle it or we catch exception.
        // Let's check count manually for user friendliness.
        if ($feeStructure->subscriptions()->count() > 0) {
            return back()->with('error', 'Cannot delete this structure as it is assigned to members.');
        }

        $feeStructure->delete();

        return redirect()->route('admin.finance.fee-structures.index')
            ->with('success', 'Fee Structure deleted successfully.');
    }
}
