<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DocumentCategory;
use Illuminate\Http\Request;

class DocumentCategoryController extends Controller
{
    public function index()
    {
        $categories = DocumentCategory::withCount('documents')->get();
        return view('admin.resources.documents.categories.index', compact('categories'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|unique:document_categories,name',
            'description' => 'nullable|string',
        ]);

        DocumentCategory::create($validated);

        return back()->with('success', 'Category created.');
    }

    public function update(Request $request, DocumentCategory $category)
    {
         $validated = $request->validate([
            'name' => 'required|string|unique:document_categories,name,' . $category->id,
            'description' => 'nullable|string',
        ]);

        $category->update($validated);

        return back()->with('success', 'Category updated.');
    }

    public function destroy(DocumentCategory $category)
    {
        if ($category->documents()->exists()) {
            return back()->with('error', 'Cannot delete category with documents.');
        }
        $category->delete();
        return back()->with('success', 'Category deleted.');
    }
}
