<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\Grievance;
use App\Models\Member;
use App\Models\Message;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        // Messages
        $totalMessages = Message::count();
        $unreadMessages = Message::where('is_read', false)->count();

        // Members
        $totalMembers = Member::count();
        $newMembersCount = Member::where('joined_at', '>=', now()->subMonth())->count();

        // Grievances
        $activeCases = Grievance::where('status', '!=', 'resolved')->count();

        // Events
        $upcomingEvents = Event::upcoming()->count();
        $nextEvent = Event::upcoming()->first();

        // View
        return view('dashboard', compact(
            'totalMessages',
            'unreadMessages',
            'totalMembers',
            'newMembersCount',
            'activeCases',
            'upcomingEvents',
            'nextEvent'
        ));
    }
}
