<?php

namespace App\Helpers;

use Exception;
use Illuminate\Support\Str;

class EnvironmentManager
{
    /**
     * @var string
     */
    private $envPath;

    /**
     * @var string
     */
    private $envExamplePath;

    public function __construct()
    {
        $this->envPath = base_path('.env');
        $this->envExamplePath = base_path('.env.example');
    }

    /**
     * Get the content of the .env file.
     *
     * @return string
     */
    public function getEnvContent()
    {
        if (!file_exists($this->envPath)) {
            if (file_exists($this->envExamplePath)) {
                return file_get_contents($this->envExamplePath);
            }
            return '';
        }

        return file_get_contents($this->envPath);
    }

    /**
     * Save the edited content to the .env file.
     *
     * @param array $data
     * @return string
     */
    public function saveFileWizard(array $data)
    {
        $results = 'Title';
        $envFileData = $this->getEnvContent();

        try {
            foreach ($data as $key => $value) {
                $key = strtoupper($key);
                // Wrap strings with spaces in quotes
                if (str_contains($value, ' ') && !str_starts_with($value, '"')) {
                    $value = '"' . $value . '"';
                }
                
                $arg = "$key=$value";
                
                $envFileData = preg_replace(
                    "/^{$key}=.*/m", 
                    $arg, 
                    $envFileData
                );
                
                // If key doesn't exist, append it (simple check)
                if (!str_contains($envFileData, "$key=")) {
                   $envFileData .= "\n$arg";
                }
            }

            file_put_contents($this->envPath, $envFileData);
            
            $results = 'Environment settings saved successfully.';
            
        } catch (Exception $e) {
            $results = 'Unable to save the .env file, Please create it manually.';
        }

        return $results;
    }
}
