<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class ProcessScheduledMessages extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'messages:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process scheduled messages and send notifications';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $messages = \App\Models\Message::where('status', 'scheduled')
            ->where('published_at', '<=', now())
            ->get();

        $count = 0;

        foreach ($messages as $message) {
            $message->status = 'published';
            $message->save();
            $count++;

            $this->info("Publishing message: {$message->title}");

            // Trigger Notifications
            try {
                $fcm = new \App\Services\FcmService();
                $recipients = $message->recipients;
                $channels = $message->channels ?? ['in_app'];

                if (in_array('email', $channels)) {
                    foreach ($recipients as $recipient) {
                        \Illuminate\Support\Facades\Log::info("Sending Scheduled Email to {$recipient->email}: {$message->title}");
                    }
                }

                if (in_array('push', $channels)) {
                    if ($message->recipient_type === 'all') {
                        $fcm->sendToTopic('all_members', $message->title, strip_tags($message->content), ['message_id' => $message->id, 'type' => $message->type]);
                    } else {
                        $tokens = $recipients->pluck('fcm_token')->filter()->values()->all();
                        if (!empty($tokens)) {
                            $fcm->sendMulticast($tokens, $message->title, strip_tags($message->content), ['message_id' => $message->id, 'type' => $message->type]);
                        }
                    }
                }

            } catch (\Exception $e) {
                \Illuminate\Support\Facades\Log::error("Error sending scheduled notification for Message ID {$message->id}: " . $e->getMessage());
            }
        }

        $this->info("Processed {$count} scheduled messages.");
    }
}
