<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class ProcessEventReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'events:reminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process pending event reminders';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $reminders = \App\Models\EventReminder::where('status', 'pending')
            ->whereHas('event', function ($query) {
                $query->where('status', '!=', 'cancelled');
            })
            ->with('event')
            ->get();

        foreach ($reminders as $reminder) {
            $event = $reminder->event;
            $reminderTime = $event->start_time->copy();

            if ($reminder->unit === 'days') {
                $reminderTime->subDays($reminder->value);
            } elseif ($reminder->unit === 'hours') {
                $reminderTime->subHours($reminder->value);
            }

            if ($reminderTime->isPast()) { // It's time to send
                // Dispatch notification
                $this->info("Sending reminder for event: {$event->title} ({$reminder->value} {$reminder->unit} before)");
                logger()->info("Event Reminder dispatched for #{$event->id} via " . implode(',', $reminder->channels));

                $reminder->update([
                    'status' => 'processed',
                    'processed_at' => now(),
                ]);
            }
        }
    }
}
