# Deployment Guide for MTWU Webadmin

This guide details how to deploy the MTWU Webadmin application to a production server using Docker.

## Prerequisites

- **Server**: Linux server (Ubuntu 20.04/22.04 LTS recommended)
- **Software**: 
    - [Docker Engine](https://docs.docker.com/engine/install/)
    - [Docker Compose](https://docs.docker.com/compose/install/)
    - Git

## Installation Steps

1.  **Clone the Repository**
    ```bash
    git clone https://github.com/YourRepo/mtwu_app.git
    cd mtwu_app
    ```

2.  **Setup Environment Variables**
    - Copy the production example:
        ```bash
        cp .env.production.example .env.production
        ```
    - Edit `.env.production` and set your secrets (Database passwords, App Key, etc.):
        ```bash
        nano .env.production
        ```
    > [!IMPORTANT]
    > Ensure `APP_ENV=production` and `APP_DEBUG=false` are set.
    > Set a strong `DB_PASSWORD` and `REDIS_PASSWORD`.

3.  **Build and Start Containers**
    ```bash
    # Build the images (this may take a few minutes)
    docker-compose -f docker-compose.prod.yml build

    # Start the services in detached mode
    docker-compose -f docker-compose.prod.yml up -d
    ```

4.  **Initial Setup (First Deployment Only)**
    - Generate App Key (if not set in .env):
        ```bash
        docker-compose -f docker-compose.prod.yml exec app php artisan key:generate
        ```
    - Run Migrations:
        ```bash
        docker-compose -f docker-compose.prod.yml exec app php artisan migrate --force
        ```
    - (Optional) Seed Initial Data:
        ```bash
        docker-compose -f docker-compose.prod.yml exec app php artisan db:seed --force
        ```

5.  **Verify Deployment**
    - Check status of containers:
        ```bash
        docker-compose -f docker-compose.prod.yml ps
        ```
    - Visit your domain or IP address in the browser.

## Updating the Application

To deploy a new version:

1.  **Pull latest changes**
    ```bash
    git pull origin main
    ```

2.  **Rebuild and Restart**
    ```bash
    docker-compose -f docker-compose.prod.yml up -d --build
    ```
    *Note: The `entrypoint.sh` script automatically caches config/routes and runs migrations on startup.*

## Logs and Troubleshooting

- **View Logs**:
    ```bash
    docker-compose -f docker-compose.prod.yml logs -f
    ```
- **Access App Container**:
    ```bash
    docker-compose -f docker-compose.prod.yml exec app /bin/bash
    ```
